<?php

namespace App\Http\Controllers\Site;

use App\Http\Controllers\Controller;
use App\Helpers\Cart;
use App\Model\Article;
use App\Model\Text;

class BaseController extends Controller
{

    public function __construct()
    {
        // 5.3 breaks that ability with anything that uses session, auth, csrf, etc so this is the reasonable alternative in my mind.
        // we don't have acces to app.locale wihout midleware.
        // https://josephsilber.com/posts/2017/01/23/getting-current-user-in-laravel-controller-constructor#table-of-contents

        if ($wp_id = request()->get('p')) {
            $article = Article::where('wp_id', $wp_id)->first();
            if ($article) {
                redirect($article->getRecipeUrl(), 301)->send();
            } else {
                redirect(route('site.'), 301)->send();
            }
        }

        parent::__construct();

        return;

        $this->middleware(function ($request, $next) {

            return $next($request);
        });


        parent::__construct();
    }

    public function loadTexts($slugs)
    {
        $texts = Text::whereIn('slug', $slugs)->get()->mapWithKeys(function ($item) {
            return [$item->slug => $item];
        });

        view()->share('texts', $texts);
    }

}
