<?php

namespace App\Http\Controllers\Site;

use App\Helpers\StringOperation;
use App\Model\Article;
use App\Model\Category;
use App\Model\Review;
use App\Model\Tag;
use Illuminate\Http\Request;
use App\Http\Requests\StoreReview;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

use Image;
use File;

class ArticleController extends BaseController
{

    public function showPage(Article $article)
    {

//        view()->share('current_section', $article->slug);

//        if (in_array($article->slug, [
//
//        ])) {
//            view()->share('current_section', 'about');
//        }

        if (!$article->isPage()) {
//            return redirect()->route('site.products');
            abort(404);
        }


        return view()->first([
            "site/article/page/{$article->slug}",
            "site/article/page/default",
//            "errors.404"
        ], compact('article'));
    }

    public function index(Category $category, Request $request)
    {
        view()->share('current_section', 'recipe');

        $is_recipe = true;
        if ($category->exists) {
            $articles = $category->articles();
        } elseif (request()->route()->getName() === 'site.recipes.index') {
            $articles = Article::recipe();
        } else {
            $articles = Article::blog();
            view()->share('current_section', 'blog');
            $is_recipe = false;
        }

        $articles->selectPartial()
            ->active()->with('photo');


        $articles = $articles
            ->when($request->get('q'), function ($q, $search_query) {
                $q->search($search_query);
            })
            ->when(!$request->get('q'), function($q) {
                $q->recent();
            })
            ->paginate(config('pagination.items_per_page'))
            ->appends($request->except('page'));

//        return $articles;

        if ($is_recipe) {
            return view('site.recipe.index', compact('articles', 'category'));
	}
        return view('site.article.index', compact('articles', 'category'));
    }

// @quikfix
    public function showBlogArticle($slug, Article $article)
    {
        view()->share('current_section', 'blog');

        if ($article->status == 'hidden') {
            abort(404);
        }

        // @quikfix redirect recipe
        if ($article->category_id !== config('categories_mapping.articles')) {
            return redirect($article->getRecipeUrl());
        }

        if ($slug != $article->slug) {
            return redirect($article->getUrl());
        }

        $reviews = $article->comment_count > 0 ? $article->reviews()->with('user')->recent()->active()->limit(300)->get() : collect([]);
        $reviews = Review::tree($reviews);

        return view('site.article.show', compact('article', 'reviews') + [
                //'recent_articles' => RecentArticles::instance()->allWithDB($article),
                'articles' => $article->getSimilar(3),
            ]);
    }

    public function indexByTag(Tag $tag)
    {
        $articles = $tag->articles()
            ->selectPartial()
            ->recipe()
            ->active()
            ->with('photo')
            ->recent()
//            ->search($tag)
            ->paginate(config('pagination.items_per_page'))
            ->appends(request()->except('page'));


        return view('site.recipe.index', compact('articles', 'tag'));

    }

    public function show($slug, Article $article, $two = false)
    {
        view()->share('current_section', 'recipe-details');

        if ($article->status == 'hidden') {
            abort(404);
        }


//         redirect if slug changed
        if ($slug != $article->slug) {
            return redirect($article->getUrl());
        }

        $category = $article->category;

//        $next = $article->blog()->active()
//            ->where('published_at', '>', $article->published_at)
//            ->orderBy('published_at')
//            ->first();
//
//        $prev = $article->blog()->active()
//            ->where('published_at', '<', $article->published_at)
//                ->orderByDesc('published_at')
//                ->first();

//        $articles = Article::blog()->active()->recent()->where('id', '!=', $article->id)->take(3)->get();


        // just save an extra query if no reviews.
        $reviews = $article->comment_count > 0 ? $article->reviews()->with('user')->recent()->active()->limit(300)->get() : collect([]);
        $reviews = Review::tree($reviews);


	if($two)
	{
	    if ($article->isRecipe()) {
            $photo_root_url = StringOperation::getPhotoUrlFromNumber($article->id, 'articles', '');
            return view('site.recipe.show-two-columns', compact('article', 'category', 'photo_root_url', 'reviews') + [
                    'articles' => $article->getSimilar(3),
                ]);
        }
	}


        if ($article->isRecipe()) {
            $photo_root_url = StringOperation::getPhotoUrlFromNumber($article->id, 'articles', '');
            return view('site.recipe.show', compact('article', 'category', 'photo_root_url', 'reviews') + [
                    'articles' => $article->getSimilar(3),
                ]);
        }
        return view('site.article.show', compact('article', 'category') + [
                //'recent_articles' => RecentArticles::instance()->allWithDB($article),
                'articles' => $article->getSimilar(3),
            ]);
    }

    public function showTwo($slug, Article $article)
    {
        view()->share('current_section', 'recipe');

        if ($article->status == 'hidden') {
            abort(404);
        }

//         redirect if slug changed
        if ($slug != $article->slug) {
            return redirect($article->getUrl());
        }

        $category = $article->category;

        // just save an extra query if no reviews.
        $reviews = $article->comment_count > 0 ? $article->reviews()->with('user')->recent()->active()->limit(300)->get() : collect([]);
        $reviews = Review::tree($reviews);


        if ($article->isRecipe()) {
            $photo_root_url = StringOperation::getPhotoUrlFromNumber($article->id, 'articles', '');
            return view('site.recipe.show-two-columns', compact('article', 'category', 'photo_root_url', 'reviews') + [
                    'articles' => $article->getSimilar(3),
                ]);
        }
    }


    public function showById(Article $article)
    {
        if ($article->isRecipe()) {
            return redirect()->route('site.recipes.show', $article);
        }
        return redirect()->route('site.articles.show', [$article, $article->slug]);
    }


    public function storeReview(Article $article, Review $review, StoreReview $request)
    {
        $request->validate(
            [
                'aprot' => 'required'
            ],
            [
                'aprot.required' => 'Oh what',
            ]
        );

        $review->fill($request->all());
        $review->user_agent = $request->server('HTTP_USER_AGENT');
        $review->ip = $request->ip();

        if (auth()->user() && auth()->user()->isAdmin()) {
            $review->is_active = true;
        }


        $article->reviews()->save($review);

        if ($request->hasFile('photo')) {
            $photo = $request->file('photo');
            $basename = basename($photo->getClientOriginalName(), '.' . $photo->getClientOriginalExtension());

            // set filename, but first do a lil of cleanup.
            $review->filename = Str::slug($basename) . '-' . auth()->id() . '.jpg';

            // check if folder exists and create it recursively if N/a
            $photo_root_path = StringOperation::getCompletePathCommentPhotos($review->id, false);
            if (!File::isDirectory($photo_root_path)) {
                File::makeDirectory($photo_root_path, 0755, true);
            }

            Image::make($photo->getRealPath())
                ->resize(1000, null, function ($constraint) {
                    $constraint->aspectRatio();
                    $constraint->upsize();
                })
                ->save($photo_root_path . '/' . $review->filename);

            $review->save();
        }

        if ($review->is_active) {
            return back()->with('status', 'Comentariu adaugat.');
        }
        return back()->with('status', 'Comentariul tau a fost adaugat, acesta va fi aprobat pe site in cel mai scurt timp posibil.');
    }

}
