<?php

namespace App\Http\Controllers\Admin;

use App\Model\Video;
use Illuminate\Http\Request;

class VideoController extends BaseController
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $videos = Video::all();
        return view('admin.video.index', compact('videos'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Video $video)
    {
        return $this->edit($video);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, Video $video)
    {
        return $this->update($request, $video);
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Model\Video $video
     * @return \Illuminate\Http\Response
     */
    public function show(Video $video)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Model\Video $video
     * @return \Illuminate\Http\Response
     */
    public function edit(Video $video)
    {
        return view('admin.video.edit', compact('video'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param \App\Model\Video $video
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Video $video)
    {
        // by default we assume we got the youtube id
        $youtube_id = $request->youtube_id;

        // try to parse da url.
        $parsed_url = parse_url($request->youtube_id);

        // overwrite the id from the url if it's the case
        if (!empty($parsed_url['query'])) {
            parse_str($parsed_url['query'], $params);
            $youtube_id = $params['v'];
        }

        $video->fill([
            'youtube_id' => $youtube_id,
        ])->save();
        return redirect(route('admin.videos.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Model\Video $video
     * @return \Illuminate\Http\Response
     */
    public function destroy(Video $video)
    {
        $video->delete();
        return redirect(route('admin.videos.index'));
    }

}
