<?php

namespace App\Http\Controllers\Admin;

use App\Model\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use StringOperation;
use Hash;
use DB;

class UserController extends BaseController {

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
        $users = User::withCount(['orders as orders_sum' => function($query) {
            $query->select(DB::raw('sum(price)'));
        }])
            ->where($request->except(['q', 'page']));
        // search?
        if ($q = $request->get('q')) {
            $q = StringOperation::getSearchableText($q);
            $users = $users->where('name', 'like', $q)
                ->orWhere(function ($query) use ($q) {
                    $query->where('email', 'like', $q);
                    //  ->orWhere('email', 'like', $q)
                    //   ->orWhere('company_name', 'like', $q);
                });
        }
        $users->when(request('type') === 'reseller', function($q) {
            $q->orderBy('is_active');
        });
        $users = $users->orderByDesc('orders_sum');
        // paginate
        $users = $users->paginate(config('pagination.items_per_page'));

        return view('admin.user.index', compact('users'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Model\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show(User $user) {
        return view('admin.user.show', compact('user'));
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Model\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit(User $user) {
        return view('admin.user.edit', compact('user'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Model\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, User $user) {
        $user->fill($request->all());
        if ($new_password = $request->get('new_password')) {
            $user->password = Hash::make($new_password);
        }
        $user->save();

        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Model\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user) {
        $user->delete();

        return back();
    }

}
