<?php

namespace App\Http\Controllers\Admin;

use App\Model\Article;
use App\Model\Cuisine;
use App\Model\Order\OrderProduct;
use App\Model\Product;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;


class IndexController extends BaseController
{

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        if (request('x')) {
            $articles = Article::all();
            $cuisines = $articles->map(function ($item) {
                return $item->params->cuisine ?? null;
            })->filter()->unique()->toArray();
            dd($cuisines);
            foreach ($cuisines as $cuisine) {
                Cuisine::firstOrCreate([
                    'name' => $cuisine,
                    'is_active' => 1,
                ]);
            }
        }

        return view('admin.index');
    }

}
