<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\StringOperation;
use App\Model\Cover;
use Illuminate\Http\Request;
use Image;
use Illuminate\Support\Str;
use App\Http\Requests\StoreMixed;

class CoverController extends BaseController
{

    public function index()
    {
        $covers = Cover::all();
        return view('admin.cover.index', compact('covers'));
    }

    public function create(Cover $cover)
    {
        return view('admin.cover.edit', compact('cover'));
    }

    public function store(StoreMixed $request, Cover $cover)
    {
        return $this->update($request, $cover);
    }


    public function show(Cover $cover)
    {
        //
    }

    public function edit(Cover $cover)
    {
        return view('admin.cover.edit', compact('cover'));
    }


    public function update(StoreMixed $request, Cover $cover)
    {
        $cover->fill($request->except(['photo', 'product_photo', 'file']));

        // photo
        if ($request->hasFile('photo')) {
            $photo = $request->file('photo');
            $basename = basename($photo->getClientOriginalName(), '.' . $photo->getClientOriginalExtension());

            // set filename, but first do a lil of cleanup.
            $cover->filename = Str::slug($basename) . '.' . strtolower($photo->getClientOriginalExtension());

            Image::make($photo->getRealPath())
                ->resize(2000, null, function ($constraint) {
                    $constraint->aspectRatio();
                    $constraint->upsize();
                })
                ->save(StringOperation::getCompletePathCovers($cover->filename));
        }

        if ($request->hasFile('product_photo')) {
            $product_photo = $request->file('product_photo');
            $basename = basename($product_photo->getClientOriginalName(), '.' . $product_photo->getClientOriginalExtension());

            // set filename, but first do a lil of cleanup.
            $cover->product_filename = Str::slug($basename) . '.' . strtolower($product_photo->getClientOriginalExtension());

            Image::make($product_photo->getRealPath())
                ->resize(600, null, function ($constraint) {
                    $constraint->aspectRatio();
                    $constraint->upsize();
                })
                ->save(StringOperation::getCompletePathProductCovers($cover->product_filename));
        }

//        // catalog
//        if ($request->hasFile('file')) {
//            $file = $request->file('file');
//            $basename = basename($file->getClientOriginalName(), '.' . $file->getClientOriginalExtension());
//
//            // set filename, but first do a lil of cleanup.
//            $cover->catalog_filename = basename($request->file('file')->storeAs(config('paths.catalogs'), Str::slug($basename) . '.' . strtolower($file->getClientOriginalExtension())));
//        }

        $cover->save();

        // update status only
        if ($request->has('is_active') && !$request->hasFile('photo')) {
            return back()->with('status', 'Actaulizat cu success');
        }

        return redirect(route('admin.covers.index'));
    }

    public function destroy(Cover $cover)
    {
        $cover->delete();
        return redirect(route('admin.covers.index'));
    }

}
