<?php

namespace App\Http\Controllers\Admin;

use App\Model\Attribute;
use App\Model\Category;
use App\Model\Category\CategoryAttribute;
use App\Model\Attribute\AttributeValue;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoreCategory;
use function foo\func;
use Illuminate\Http\Request;
use Utils;

class CategoryController extends BaseController
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

//        $attributes = Category::find(1)->attributes;
//        foreach ($attributes as $attribute) {
//            dump($attribute->toArray());
//        }
//        dd();

        // get all categoires.
        $base_categories = Category::priority()->get();
        $categories = Category::tree($base_categories); // Category::root()->get();
        return view('admin.category.index', compact('categories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Category $category)
    {
        return $this->edit($category);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreCategory $request, Category $category)
    {
        return $this->update($request, $category);
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Model\Category $category
     * @return \Illuminate\Http\Response
     */
    public function show(Category $category)
    {
        return view('admin.category.show', compact('category'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Model\Category $category
     * @return \Illuminate\Http\Response
     */
    public function edit(Category $category)
    {
        if (request('parent_id')) {
            $category->parent_id = request('parent_id');
        }

        // we don't need infinite level of nesting
//        $categories = Category::tree();
        $categories = Category::root()->get();


        return view('admin.category.edit', compact('category', 'categories'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param \App\Model\Category $category
     * @return \Illuminate\Http\Response
     */
    public function update(StoreCategory $request, Category $category)
    {
        $category->fill($request->except('photo'));
        $category->save();

        if ($request->hasFile('photo')) {
            $category->photo = basename($request->photo->storeAs('categories', implode('.', [$category->slug, $request->photo->getClientOriginalExtension()])));
            $category->save();
        }

        return redirect(route('admin.categories.index'));

        return redirect(route('admin.categories.edit', $category));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Model\Category $category
     * @return \Illuminate\Http\Response
     */
    public function destroy(Category $category)
    {
        $category->delete();
        return back();
    }

    public function priority(Request $request)
    {

        foreach ($request->get('priority') as $id => $priority) {
            $category = Category::find($id);
            $category->unsetEventDispatcher();

            $category->priority = $priority;
            $category->save();
        }
    }
}
