<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\Article;
use App\Model\Article\ArticleDocument as Document;
use App\Http\Requests\StoreDocument;

use StringOperation;
use Str;

class ArticleDocumentController extends Controller {

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Article $article, StoreDocument $request) {
        //dd($request->file('file')->getMimeType());
        $filename_processed = implode('.', [
            Str::slug(basename($request->file('file')->getClientOriginalName(), '.' . $request->file('file')->getClientOriginalExtension())),
            strtolower($request->file('file')->getClientOriginalExtension())
        ]);
        $filepath = $request->file('file')->storeAs(config('paths.documents') . '/' . StringOperation::convertNumberToPath($article->id, true), $filename_processed);

        $document = new Document;
        $document->fill([
            'name' => $request->get('name'),
            'filename' => basename($filepath),
        ]);
        $article->documents()->save($document);
        $request->session()->flash('status', 'Fisier salvat.');

        return redirect(route('admin.articles.edit', [$article, 'tab' => 'files']));
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Model\Article  $article
     * @return \Illuminate\Http\Response
     */
    public function show(Article $article) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Model\Article  $article
     * @return \Illuminate\Http\Response
     */
    public function edit(Article $article) {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Model\Article  $article
     * @return \Illuminate\Http\Response
     */
    public function update(Article $article, Document $document, StoreDocument $request) {
        $document->fill($request->all())->save();
        return redirect(route('admin.articles.edit', [$article, 'tab' => 'files']));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Model\Article  $article
     * @return \Illuminate\Http\Response
     */
    public function destroy(Article $article, Document $document) {
        $article->documents()->find($document->id)->delete();
        return redirect(route('admin.articles.edit', [$article, 'tab' => 'files']));
    }

}
